/*global redux_change, redux*/

(function ($) {
    "use strict";

    redux.field_objects = redux.field_objects || {};
    redux.field_objects.travelpayouts_sortby = redux.field_objects.travelpayouts_sortby || {};

    redux.field_objects.travelpayouts_sortby.init = function (selector) {
        if (!selector) {
            selector = $(document).find('.redux-container-travelpayouts_sortby:visible');
        }

        $(selector).each(
            function () {
                var el = $(this);
                var parent = el;

                if (!el.hasClass('redux-field-container')) {
                    parent = el.parents('.redux-field-container:first');
                }
                if (parent.is(":hidden")) { // Skip hidden fields
                    return;
                }
                if (parent.hasClass('redux-field-init')) {
                    parent.removeClass('redux-field-init');
                } else {
                    return;
                }

                el.find('select.redux-select-item').each(
                    function () {

                        var selectSortby = $(this);
                        var selectedLast = selectSortby.parents('fieldset').find('select option[selected="selected"]').val();

                        var default_params = {
                            width: 'resolve',
                            triggerChange: true,
                            allowClear: true
                        };
                        if ($(this).attr('multiple') == "multiple") {
                            default_params.width = "100%";
                        }

                        if ($(this).siblings('.select2_params').size() > 0) {
                            var select2_params = $(this).siblings('.select2_params').val();
                            select2_params = JSON.parse(select2_params);
                            default_params = $.extend({}, default_params, select2_params);
                        }

                        if ($(this).hasClass('font-icons')) {
                            default_params = $.extend(
                                {}, {
                                    formatResult: redux.field_objects.select.addIcon,
                                    formatSelection: redux.field_objects.select.addIcon,
                                    escapeMarkup: function (m) {
                                        return m;
                                    }
                                }, default_params
                            );
                        }

                        $(this).select2(default_params);

                        if ($(this).hasClass('select2-sortable')) {
                            default_params = {};
                            default_params.bindOrder = 'sortableStop';
                            default_params.sortableOptions = {placeholder: 'ui-state-highlight'};
                            $(this).select2Sortable(default_params);
                        }

                        $(this).on(
                            "change", function () {
                                redux_change($($(this)));
                                $(this).select2SortableOrder();
                            }
                        );

                        $(this).parents('.form-table').find('.redux-container-travelpayouts_sorter .redux-sorter').on(
                            "sortout", function () {
                                let sorterId = $(this).parents('.form-table').find('.redux-container-travelpayouts_sorter').data('id');
                                let enabledIds = $('#' + sorterId).find('ul').sortable("toArray");

                                selectSortby.empty(); // remove old options
                                $.each(enabledIds, function (key, value) {
                                    let optionText = $('#' + value).find('input').val();
                                    if (value !== '' && value.length > 0 && typeof optionText !== 'undefined' && optionText.length > 0) {
                                        value = value.replace('sortee-', '');

                                        let option = $("<option></option>")
                                            .attr("value", value)
                                            .text(optionText);

                                        if (value === selectedLast) {
                                            option.attr('selected', 'selected');
                                        }

                                        selectSortby.append(option);
                                    }
                                });
                            }
                        );
                    }
                );
            }
        );
    };

    redux.field_objects.travelpayouts_sortby.addIcon = function (icon) {
        if (icon.hasOwnProperty('id')) {
            return "<span class='elusive'><i class='" + icon.id + "'></i>" + "&nbsp;&nbsp;" + icon.text + "</span>";
        }
    };
})(jQuery);