<?php
    session_start();
    include "databaseConnect.php";

    $type = '';
    if(isset($_POST['type']) && !empty($_POST['type'])){
        $type = $_POST['type'];
    }

    if ($type === "addForm") {
        $hotelName = mysqli_real_escape_string($conn, $_POST['addhotelName']);
        $pageHeading = mysqli_real_escape_string($conn, $_POST['addPageHeading']);
        $hotelLink = mysqli_real_escape_string($conn, $_POST['addhotelLink']);
        $ratingComment = mysqli_real_escape_string($conn, $_POST['addRatingComment']);
        $reviewNumber = mysqli_real_escape_string($conn, $_POST['addReviewNumber']);
        $pricing = mysqli_real_escape_string($conn, $_POST['addPricing']);
        $freeCancellation = isset($_POST['addFreeCancellation']) ? 1 : 0;
        $noPrePayment = isset($_POST['addNoPre-payment']) ? 1 : 0;
        $hotelAddress = mysqli_real_escape_string($conn, $_POST['addHotelAddress']);
        $googleMapURL = mysqli_real_escape_string($conn, $_POST['googleMapURL']);
        $slugUrl = mysqli_real_escape_string($conn, $_POST['addslugUrl']);
        $amenities = mysqli_real_escape_string($conn, $_POST['hotelAmenities']);
        $addImageURL = mysqli_real_escape_string($conn, $_POST['addImageURL']);


        $uploadDir = 'images/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }
    
        $imageURL = '';
        if (isset($_FILES['addPageImageURL']) && $_FILES['addPageImageURL']['error'] === 0) {
            $imageTmpName = $_FILES['addPageImageURL']['tmp_name'];
            $imageName = uniqid() . '-' . basename($_FILES['addPageImageURL']['name']);
            $imagePath = $uploadDir . $imageName;
    
            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif'];
            if (in_array($_FILES['addPageImageURL']['type'], $allowedTypes)) {
                if (move_uploaded_file($imageTmpName, $imagePath)) {
                    $imageURL = $imageName;
                } else {
                    echo json_encode(["success" => false, "message" => "Failed to upload image."]);
                    exit;
                }
            } else {
                echo json_encode(["success" => false, "message" => "Invalid image type. Only JPG, PNG, and GIF are allowed."]);
                exit;
            }
        }
    
        $sql = "INSERT INTO tblhoteldetails (hotel_name, hotel_link, rating_comment, review_number, pricing, free_cancellation, no_pre_payment, hotel_address, image_url, hotel_location , slug, amenities, page_heading, page_backgroung_Image)
                VALUES ('$hotelName', '$hotelLink', '$ratingComment', '$reviewNumber', '$pricing', '$freeCancellation', '$noPrePayment', '$hotelAddress', '$addImageURL', '$googleMapURL', '$slugUrl', '$amenities', '$pageHeading', '$imageURL')";
    
        if (mysqli_query($conn, $sql)) {
            echo json_encode(["success" => true, "message" => "Hotel added successfully"]);
        } else {
            echo json_encode(["success" => false, "message" => "Error: " . mysqli_error($conn)]);
        }
    }else if($type === 'editForm') {
        $hotel_id = mysqli_real_escape_string($conn, $_POST['hotelID']);
        $hotelName = mysqli_real_escape_string($conn, $_POST['edithotelName']);
        $pageHeading = mysqli_real_escape_string($conn, $_POST['editPageHeading']);
        $hotelLink = mysqli_real_escape_string($conn, $_POST['edithotelLink']);
        $ratingComment = mysqli_real_escape_string($conn, $_POST['editRatingComment']);
        $reviewNumber = mysqli_real_escape_string($conn, $_POST['editReviewNumber']);
        $pricing = mysqli_real_escape_string($conn, $_POST['editPricing']);
        $freeCancellation = isset($_POST['editFreeCancellation']) ? 1 : 0;
        $noPrePayment = isset($_POST['editNoPre-payment']) ? 1 : 0;
        $hotelAddress = mysqli_real_escape_string($conn, $_POST['editHoteleditress']);
        $googleMapURL = mysqli_real_escape_string($conn, $_POST['editgoogleMapURL']);
        $slugUrl = mysqli_real_escape_string($conn, $_POST['editslug']);
        $amenities = mysqli_real_escape_string($conn, $_POST['hotelAmenities']);
        $editImageURL = mysqli_real_escape_string($conn, $_POST['editImageURL']);

    
        if (isset($_FILES['editImageFile']) && $_FILES['editImageFile']['error'] == UPLOAD_ERR_OK) {
            $imageURL = mysqli_real_escape_string($conn, $_POST['editImageURL']);
            $targetDir = "images/";
            $targetFile = $targetDir . basename($_FILES['editImageFile']['name']);
            $imageFileType = strtolower(pathinfo($targetFile, PATHINFO_EXTENSION));
    
            $validExtensions = ["jpg", "jpeg", "png", "gif"];
            if (!in_array($imageFileType, $validExtensions)) {
                die("Invalid file type. Only JPG, JPEG, PNG & GIF are allowed.");
            }
            if ($_FILES['editImageFile']['size'] > 2000000) { 
                die("File size exceeds limit. Max 2MB allowed.");
            }
    
            if (move_uploaded_file($_FILES['editImageFile']['tmp_name'], $targetFile)) {
                $imageURL = basename($_FILES['editImageFile']['name']); 
            } else {
                die("Failed to upload image.");
            }
        }else{
            $imageURL = mysqli_real_escape_string($conn, $_POST['editImageURL_older']);
        }
    
        $sql = "UPDATE tblhoteldetails SET 
                    hotel_name = '$hotelName', 
                    hotel_link = '$hotelLink', 
                    rating_comment = '$ratingComment',
                    review_number = '$reviewNumber',
                    pricing = '$pricing',
                    free_cancellation = '$freeCancellation',
                    no_pre_payment = '$noPrePayment',
                    hotel_address = '$hotelAddress',
                    image_url = '$editImageURL',
                    hotel_location = '$googleMapURL',
                    slug = '$slugUrl',
                    amenities = '$amenities',
                    page_heading = '$pageHeading',
                    page_backgroung_Image = '$imageURL'
                WHERE hotel_id = '$hotel_id'";
    
        if (mysqli_query($conn, $sql)) {
            header('location:admin.php?msg=success');
        } else {
            echo json_encode(["success" => false, "message" => "Error: " . mysqli_error($conn)]);
        }
    }else if($type === 'addFormsidebar-1'){
        $slug = mysqli_real_escape_string($conn, $_POST['addBySlug']);
        $hotelAttractionsContent = mysqli_real_escape_string($conn, $_POST['hotelAttractionsContent']);

        $sql = "INSERT INTO tbltopattractions (slug, hotelAttractionsContent) VALUES ('$slug', '$hotelAttractionsContent')";
        if (mysqli_query($conn, $sql)) {
            echo "Data inserted successfully!";
            header("Location: top-attractions.php?message=success");
            exit;
        } else {
            echo "Error: " . mysqli_error($conn);
        }
    }else if($type === 'editFormsidebar-1'){
        $id = intval($_POST['id']);
        $slug = mysqli_real_escape_string($conn, $_POST['addBySlug']);
        $hotelAttractionsContent = mysqli_real_escape_string($conn, $_POST['hotelAttractionsContent']);

        if (empty($id)) {
            echo "Invalid ID.";
            exit;
        }
        if (empty($slug)) {
            echo "Slug is required.";
            exit;
        }
        if (empty($hotelAttractionsContent)) {
            echo "Attractions Content is required.";
            exit;
        }

        $sql = "UPDATE tbltopattractions 
                SET slug = '$slug', hotelAttractionsContent = '$hotelAttractionsContent' 
                WHERE id = $id";

        if (mysqli_query($conn, $sql)) {
            echo "Data updated successfully!";
            header("Location:time-to-visit.php?message=success");
            exit;
        } else {
            echo "Error: " . mysqli_error($conn);
        }
    }else if($type === 'addFormsidebar-2'){
        $slug = isset($_POST['addBySlug']) ? trim($_POST['addBySlug']) : '';
        $timeToVisitContent = isset($_POST['hoteltimeToVisitContent']) ? trim($_POST['hoteltimeToVisitContent']) : '';
        
        if (empty($slug)) {
            echo json_encode(['status' => 'error', 'message' => 'Slug is required.']);
            exit;
        }
    
        if (empty($timeToVisitContent)) {
            echo json_encode(['status' => 'error', 'message' => 'Content for Best Time to Visit is required.']);
            exit;
        }

        $sql = "INSERT INTO tbltimetovisit (slug, timetovisitcontent) VALUES ('$slug', '$timeToVisitContent')";
        if (mysqli_query($conn, $sql)) {
            echo "Data inserted successfully!";
            header("Location: time-to-visit.php?message=success");
            exit;
        } else {
            echo "Error: " . mysqli_error($conn);
        }

    }else if($type === 'editFormsidebar-2'){
        $id = isset($_POST['id']) ? intval($_POST['id']) : 0;
        $slug = isset($_POST['addBySlug']) ? trim($_POST['addBySlug']) : '';
        $timeToVisitContent = isset($_POST['hoteledittimetovisit']) ? trim($_POST['hoteledittimetovisit']) : '';

        if (empty($id)) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid ID.']);
            exit;
        }

        if (empty($slug)) {
            echo json_encode(['status' => 'error', 'message' => 'Slug is required.']);
            exit;
        }

        if (empty($timeToVisitContent)) {
            echo json_encode(['status' => 'error', 'message' => 'Content for Best Time to Visit is required.']);
            exit;
        }

        $sql = "UPDATE tbltimetovisit 
                SET slug = '$slug', timetovisitcontent = '$timeToVisitContent' 
                WHERE id = $id";

        if (mysqli_query($conn, $sql)) {
            echo "Data updated successfully!";
            header("Location: time-to-visit.php?message=success");
            exit;
        } else {
            echo "Error: " . mysqli_error($conn);
        }
    }
    mysqli_close($conn);
?>
