<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_content_empty' ) ) {
	function foxiz_content_empty() { ?>
		<div class="section-not-found not-found">
			<div class="wrap rb-container gutter-p20">
				<div class="not-found-inner">
					<header class="page-header">
						<h1 class="page-title"><?php foxiz_html_e( 'Nothing Found', 'foxiz' ) ?></h1>
					</header>
					<div class="page-content entry-content rbct">
						<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
							<p><?php printf( foxiz_html__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'foxiz' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
						<?php else: ?>
							<p><?php foxiz_html_e( 'It looks like nothing was found at this location. Maybe try a search?', 'foxiz' ); ?></p>
							<?php get_search_form(); ?>
							<?php if ( ! is_front_page() ) : ?>
								<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="return-home h6" title="<?php echo foxiz_attr__( 'Return to Home', 'foxiz' ); ?>"><?php echo foxiz_html__( 'Return to Home', 'foxiz' ); ?></a>
							<?php endif;
						endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}

if ( ! function_exists( 'foxiz_category_page_header' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_category_page_header( $settings = array() ) {
		if ( empty( $settings['category_header'] ) ) {
			foxiz_category_page_header_1( $settings );
			return false;
		}
		switch ( $settings['category_header'] ) {
			case '2' :
				foxiz_category_page_header_2( $settings );
				break;
			case '3' :
				foxiz_category_page_header_3( $settings );
				break;
			case '4' :
				foxiz_category_page_header_4( $settings );
				break;
			case 'none':
				break;
			default:
				foxiz_category_page_header_1( $settings );
		}

		return false;
	}
}

if ( ! function_exists( 'foxiz_category_page_header_1' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_category_page_header_1( $settings = array() ) {
		$class_name = 'archive-header category-header-1';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		}
		?>
		<header class="<?php echo esc_attr( $class_name ); ?>">
			<div class="rb-container edge-padding">
				<div class="archive-inner">
					<div class="archive-header-content">
						<?php if ( ! empty( $settings['breadcrumb'] ) ) {
							echo foxiz_get_breadcrumb( 'archive-breadcrumb' );
						} ?>
						<h1 class="archive-title"><?php single_cat_title( '', true ); ?></h1>
						<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
						<?php if ( ! empty( $settings['subcategory'] ) ) :
							$categories = get_categories(
								array(
									'parent'     => $settings['category'],
									'hide_empty' => false
								) );
							if ( count( $categories ) ): ?>
								<div class="subcat-wrap">
                                    <span class="subcat-heading"><i class="rbi rbi-share"></i><?php foxiz_html_e( 'Find More:', 'foxiz' ) ?></span>
									<?php foreach ( $categories as $category ) : ?>
                                        <span class="sub-cat-item h5">
                                                     <a href="<?php echo get_category_link( $category->term_id ) ?>"><?php echo esc_html( $category->name ); ?></a>
                                                </span>
									<?php endforeach; ?>
								</div>
							<?php endif;
						endif; ?>
					</div>
					<?php if ( ! empty( $settings['featured_image'] ) ) {
						if ( empty( $settings['featured_image_urls'] ) ) {
							$settings['featured_image_urls'] = array();
						}
						echo '<div class="category-hero-wrap">';
						foxiz_render_category_hero( $settings['featured_image'], $settings['featured_image_urls'] );
						echo '</div>';
					} ?>
				</div>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_category_page_header_2' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_category_page_header_2( $settings = array() ) {
		$class_name = 'archive-header category-header-2';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		} ?>
		<header class="<?php echo esc_attr( $class_name ); ?>">
			<div class="rb-container edge-padding">
				<div class="archive-inner">
					<div class="archive-header-content light-scheme">
						<?php if ( ! empty( $settings['breadcrumb'] ) ) {
							echo foxiz_get_breadcrumb( 'archive-breadcrumb' );
						} ?>
						<h1 class="archive-title"><?php single_cat_title( '', true ); ?></h1>
						<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
						<?php if ( ! empty( $settings['subcategory'] ) ) :
							$categories = get_categories(
								array(
									'parent'     => $settings['category'],
									'hide_empty' => false
								) );
							if ( count( $categories ) ): ?>
								<div class="block-qlinks qlinks-layout-2">
									<div class="block-qlinks-inner">
										<ul class="qlinks-content">
											<?php foreach ( $categories as $category ) : ?>
												<li class="qlink h5">
													<a href="<?php echo get_category_link( $category->term_id ) ?>"><?php echo esc_html( $category->name ); ?></a>
												</li>
											<?php endforeach; ?>
										</ul>
									</div>
								</div>
							<?php endif;
						endif; ?>
					</div>
				</div>
				<div class="featured-category-img-overlay">
					<?php if ( ! empty( $settings['featured_image'][0] ) ) : ?>
						<img src="<?php echo esc_url( wp_get_attachment_image_url( $settings['featured_image'][0], '2048×2048' ) ); ?>" alt="<?php echo get_post_meta( $settings['featured_image'][0], '_wp_attachment_image_alt', true ); ?>">
					<?php endif; ?>
				</div>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_category_page_header_3' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_category_page_header_3( $settings = array() ) {
		$class_name = 'archive-header category-header-3';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		} ?>
		<header class="<?php echo esc_attr( $class_name ); ?>">
			<div class="rb-container edge-padding archive-header-content">
				<h1 class="archive-title"><?php single_cat_title( '', true ); ?></h1>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_category_page_header_4' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_category_page_header_4( $settings = array() ) {
		$class_name = 'archive-header category-header-4';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		} ?>
        <header class="<?php echo esc_attr( $class_name ); ?>">
            <div class="rb-container edge-padding archive-header-content">
                <h1 class="archive-title"><?php single_cat_title( '', true ); ?></h1>
	            <?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
            </div>
        </header>
	<?php }
}

if ( ! function_exists( 'foxiz_archive_page_header' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_archive_page_header( $settings = array() ) {
		$class_name = 'archive-header is-archive-page';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		} ?>
		<header class="<?php echo esc_attr( $class_name ); ?>">

			<div class="rb-container edge-padding archive-header-content">
				<?php if ( ! empty( $settings['breadcrumb'] ) ) {
					echo foxiz_get_breadcrumb( 'archive-breadcrumb' );
				} ?>
				<h1 class="archive-title"><?php echo get_the_archive_title(); ?></h1>
				<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_search_page_header' ) ) {
	/**
	 * @param array $settings
	 */
	function foxiz_search_page_header( $settings = array() ) {

		$total = 0;
		global $wp_query;
		if ( ! empty( $wp_query->found_posts ) ) {
			$total = $wp_query->found_posts;
		} ?>
		<header class="search-header">
			<div class="rb-container edge-padding">
				<div class="search-header-inner">
					<div class="search-header-content">
						<h1 class="search-title"><?php printf( foxiz_html__( 'Search Results for: %s', 'foxiz' ), get_search_query() ); ?></h1>
						<p class="search-subtitle"><?php printf( foxiz_html__( 'Showing %s results for your search', 'foxiz' ), $total ); ?></p>
					</div>
					<div class="search-header-form">
						<?php get_search_form(); ?>
					</div>
				</div>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_blog_embed_template' ) ) {
	/**
	 * @param $settings
	 *
	 * @return false
	 */
	function foxiz_blog_embed_template( $settings ) {
		if ( empty( $settings['template'] ) || ! shortcode_exists( 'Ruby_E_Template' ) ) {
			return false;
		}
		if ( ! empty( $settings['template_display'] ) && '1' === (string) $settings['template_display'] ) {
			$paged = get_query_var( 'paged' );
		}
		if ( empty( $paged ) || $paged < 2 )  : ?>
			<div class="archive-builder">
				<?php if ( has_shortcode( $settings['template'], 'Ruby_E_Template' ) ) {
					echo do_shortcode( $settings['template'] );
				} ?>
			</div>
		<?php
		endif;
	}
}


if ( ! function_exists( 'foxiz_blog_embed_template_bottom' ) ) {
	/**
	 * @param $settings
	 *
	 * @return false
	 */
	function foxiz_blog_embed_template_bottom( $settings ) {
		if ( empty( $settings['template_bottom'] ) || ! shortcode_exists( 'Ruby_E_Template' ) ) {
			return false;
		}
		if ( ! empty( $settings['template_display'] ) && '1' === (string) $settings['template_display'] ) {
			$paged = get_query_var( 'paged' );
		}
		if ( empty( $paged ) || $paged < 2 )  : ?>
            <div class="archive-builder archive-builder-bottom">
				<?php if ( has_shortcode( $settings['template_bottom'], 'Ruby_E_Template' ) ) {
					echo do_shortcode( $settings['template_bottom'] );
				} ?>
            </div>
		<?php
		endif;
	}
}

if ( ! function_exists( 'foxiz_the_blog' ) ) {
	/**
	 * @param array $settings
	 * @param null $_query
	 *
	 * @return false
	 */
	function foxiz_the_blog( $settings = array(), $_query = null ) {

		if ( ! empty( $settings['template_global'] ) ) {
			foxiz_blog_template( $settings['template_global'] );

			return false;
		}

		if ( empty( $_query ) ) {
			global $wp_query;
			$_query = $wp_query;
		}

		$classes   = array();
		$classes[] = 'blog-wrap';
		if ( ! empty( $settings['classes'] ) ) {
			$classes[] = $settings['classes'];
		}
		if ( empty( $settings['sidebar_position'] ) || 'none' === $settings['sidebar_position'] ) {
			$settings['sidebar_name'] = false;
		}
		if ( empty( $settings['sidebar_name'] ) || ! is_active_sidebar( $settings['sidebar_name'] ) ) {
			$classes[] = 'without-sidebar';
		} else {
			$classes[] = 'is-sidebar-' . esc_attr( $settings['sidebar_position'] );
		}
		if ( ! empty( $settings['sticky_sidebar'] ) ) {
			$classes[] = 'sticky-sidebar';
		} ?>
		<div class="<?php echo join( ' ', $classes ); ?>">
			<div class="rb-container edge-padding">
				<div class="grid-container">
					<div class="blog-content">
						<?php foxiz_the_blog_heading( $settings ); ?>
						<?php echo foxiz_get_blog_layout( $settings, $_query ); ?>
					</div>
					<?php if ( ! empty( $settings['sidebar_name'] ) && is_active_sidebar( $settings['sidebar_name'] ) ) : ?>
						<div class="blog-sidebar sidebar-wrap">
							<div class="sidebar-inner clearfix">
								<?php dynamic_sidebar( $settings['sidebar_name'] ); ?>
							</div>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php }
}

if ( ! function_exists( 'foxiz_get_blog_layout' ) ) {
	/**
	 * @param array $settings
	 * @param null $_query
	 *
	 * @return false|string
	 */
	function foxiz_get_blog_layout( $settings = array(), $_query = null ) {

		$layout = 'classic';
		if ( ! empty( $settings['layout'] ) ) {
			$layout = $settings['layout'];
		}
		switch ( $layout ) {
			case 'classic_1' :
				return foxiz_get_classic_1( $settings, $_query );
			case 'grid_2' :
				return foxiz_get_grid_2( $settings, $_query );
			case 'grid_box_1' :
				return foxiz_get_grid_box_1( $settings, $_query );
			case 'grid_box_2' :
				return foxiz_get_grid_box_2( $settings, $_query );
			case 'grid_small_1' :
				return foxiz_get_grid_small_1( $settings, $_query );
			case 'list_1' :
				return foxiz_get_list_1( $settings, $_query );
			case 'list_2' :
				return foxiz_get_list_2( $settings, $_query );
			case 'list_box_1' :
				return foxiz_get_list_box_1( $settings, $_query );
			case 'list_box_2' :
				return foxiz_get_list_box_2( $settings, $_query );
			case 'grid_1' :
			default:
				return foxiz_get_grid_1( $settings, $_query );
		}
	}
}

if ( ! function_exists( 'foxiz_the_blog_heading' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_the_blog_heading( $settings = array() ) {

		if ( empty( $settings['blog_heading'] ) ) {
			return false;
		}
		if ( empty( $settings['blog_heading_layout'] ) ) {
			$settings['blog_heading_layout'] = foxiz_get_option( 'heading_layout' );
		}
		if ( empty( $settings['blog_heading_layout'] ) ) {
			$settings['blog_heading_layout'] = 1;
		}
		$classes = false;

		if ( empty( $settings['blog_heading_tag'] ) ) {
			$settings['blog_heading_tag'] = 'span';
			$classes                      = 'h3';
		}

		echo foxiz_get_heading( array(
			'title'    => $settings['blog_heading'],
			'html_tag' => $settings['blog_heading_tag'],
			'classes'  => $classes,
			'layout'   => $settings['blog_heading_layout'],
		) );
	}
}

if ( ! function_exists( 'foxiz_author_page_header' ) ) {
	/**
	 * @param array $settings
	 *
	 * @return false
	 */
	function foxiz_author_page_header( $settings = array() ) {

		if ( ! foxiz_get_option( 'author_bio' ) ) {
			return false;
		}

		$author_id   = get_queried_object_id();
		$job         = get_the_author_meta( 'job', $author_id );
		$description = get_the_author_meta( 'description', $author_id );

		$class_name = 'archive-header author-header';
		if ( ! empty( $settings['pattern'] ) && '-1' !== (string) $settings['pattern'] ) {
			$class_name .= ' is-pattern pattern-' . esc_attr( $settings['pattern'] );
		} else {
			$class_name .= ' solid-bg';
		} ?>
		<header class="<?php echo esc_attr( $class_name ); ?>">
			<div class="rb-container edge-padding">
				<div class="author-header-inner">
					<?php if ( ! empty( $settings['breadcrumb'] ) ) {
						echo foxiz_get_breadcrumb( 'archive-breadcrumb' );
					} ?>
					<div class="ubio">
						<div class="ubio-inner">
							<div class="bio-info bio-avatar">
								<?php echo get_avatar( $author_id, 200 ); ?>
							</div>
							<div class="bio-content">
								<div class="bio-title">
									<h2><?php echo get_the_author_meta( 'display_name', $author_id ); ?></h2></div>
								<?php if ( ! empty( $description ) ) : ?>
									<div class="bio-description"><?php echo wp_kses( $description, 'foxiz' ); ?></div>
								<?php endif; ?>
								<?php if ( foxiz_get_social_list( foxiz_get_user_socials( $author_id ), true, false ) ) : ?>
									<div class="usocials meta-text tooltips-n">
										<?php if ( ! empty( $job ) ) : ?>
											<div class="bio-job"><?php echo wp_kses( $job, 'foxiz' ); ?></div>
										<?php endif; ?>
										<span class="ef-label"><?php foxiz_html_e( 'Follow: ', 'foxiz' ); ?></span><?php echo foxiz_get_social_list( foxiz_get_user_socials( $author_id ), true, false ); ?>
									</div>
								<?php endif; ?>
							</div>
						</div>
						<div class="bio-count-posts">
							<?php $total_posts = count_user_posts( $author_id );
							if ( $total_posts > 0 ) : ?>
							<span class="h1 bio-count"><?php echo esc_html($total_posts); ?></span>
								<span class="is-meta"><?php
									if ( (string) $total_posts === '1' ) {
										foxiz_html_e( 'Article', 'foxiz' );
									} else {
										foxiz_html_e( 'Articles', 'foxiz' );
									} ?></span>
							<?php endif; ?>
						</div>
					</div>
				</div>
			</div>
		</header>
	<?php }
}

if ( ! function_exists( 'foxiz_blog_empty' ) ) {
	function foxiz_blog_empty() { ?>
		<div class="section-empty not-found">
			<div class="rb-container edge-padding">
				<div class="section-empty-inner">
					<h1 class="page-title"><?php foxiz_html_e( 'Oops! Nothing here', 'foxiz' ); ?></h1>
					<div class="page-content entry-content rbct">
						<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
							<p><?php esc_html_e( 'Ready to publish your first post?', 'foxiz' ) ?>
								<a href="<?php echo admin_url( 'post-new.php' ); ?>"><?php esc_html_e( ' Get started here', 'foxiz' ); ?></a>
							</p>
						<?php else: ?>
							<p class="page404-description"><?php foxiz_html_e( 'It seems we can’t find what you’re looking for. Perhaps searching can help.', 'foxiz' ); ?></p>
							<?php get_search_form();
							if ( ! is_front_page() ) : ?>
								<div class="page404-btn-wrap">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="page404-btn is-btn"><?php foxiz_html_e( 'Return to Homepage', 'foxiz' ); ?></a>
								</div>
							<?php endif;
						endif; ?>
					</div>
				</div>
			</div>
		</div>
	<?php }
}

if ( ! function_exists( 'foxiz_search_empty' ) ) {
	function foxiz_search_empty() { ?>
		<div class="rb-container edge-padding">
			<div class="search-empty">
				<p class="h3"><?php foxiz_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'foxiz' ); ?></p>
			</div>
		</div>
	<?php }
}

if ( ! function_exists( 'foxiz_blog_template' ) ) {
	/**
	 * @param $shortcode
	 */
	function foxiz_blog_template( $shortcode ) {
		echo '<div class="blog-builder">' . do_shortcode( $shortcode ) . '</div>';
	}
}