<?php
/**
 * Force admin toolbar for Administrator + Editor (mu-plugin)
 * Place in wp-content/mu-plugins/force-toolbar-for-editors.php
 */

if ( ! defined( 'WPINC' ) ) {
    die;
}

/**
 * Force showing admin bar for admins and editors.
 * Use a very late priority to override other filters.
 */
add_filter( 'show_admin_bar', function( $show ) {
    // If user is not logged in, keep default
    if ( ! is_user_logged_in() ) {
        return $show;
    }

    // Always show for admins or editors
    if ( current_user_can( 'administrator' ) || current_user_can( 'editor' ) ) {
        return true;
    }

    return $show;
}, 9999 );

/**
 * Ensure editor capabilities used by toolbar items are present.
 * Run on init so role exists.
 */
add_action( 'init', function() {
    $role = get_role( 'editor' );
    if ( ! $role ) {
        return;
    }

    // Core
    $role->add_cap( 'read' );
    $role->add_cap( 'edit_posts' );
    $role->add_cap( 'edit_others_posts' );
    $role->add_cap( 'edit_pages' );
    $role->add_cap( 'edit_others_pages' );
    $role->add_cap( 'publish_posts' );
    $role->add_cap( 'publish_pages' );

    // Appearance & Menus (Customize icon, Menus)
    $role->add_cap( 'edit_theme_options' );
    $role->add_cap( 'edit_nav_menus' );

    // Elementor (if installed) — safe no-op if capability not used
    $role->add_cap( 'elementor_edit_pages' );
    $role->add_cap( 'elementor_edit_posts' );

    // RankMath / SEO placeholder — plugin-specific caps are harmless if absent
    $role->add_cap( 'rank_math_general' );
}, 20 );

/**
 * Ensure user meta preference to show the admin bar on frontend is enabled on login.
 */
add_action( 'wp_login', function( $user_login, $user ) {
    if ( ! $user instanceof WP_User ) {
        $user = get_user_by( 'login', $user_login );
    }
    if ( ! $user ) {
        return;
    }

    if ( in_array( 'editor', (array) $user->roles, true ) || in_array( 'administrator', (array) $user->roles, true ) ) {
        update_user_meta( $user->ID, 'show_admin_bar_front', 'true' );
    }
}, 10, 2 );

/**
 * As a last measure, force `show_admin_bar()` to true in frontend rendering for editors/admins.
 * This is a fallback when something else directly calls show_admin_bar(false).
 */
add_action( 'wp_head', function() {
    if ( is_user_logged_in() && ( current_user_can( 'administrator' ) || current_user_can( 'editor' ) ) ) {
        // Ensure WP's global flag is set to true
        if ( function_exists( 'show_admin_bar' ) ) {
            show_admin_bar( true );
        }
    }
}, 1 );
