<?php
/** Don't load directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'foxiz_register_options_color' ) ) {
	/**
	 * @return array
	 */
	function foxiz_register_options_color() {

		return array(
			'id'     => 'foxiz_config_section_color',
			'title'  => esc_html__( 'Global Colors', 'foxiz' ),
			'desc'   => esc_html__( 'Manage the website color.', 'foxiz' ),
			'icon'   => 'el el-tint',
			'fields' => array(
				array(
					'id'     => 'section_start_global_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Highlight Colors', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'global_color',
					'title'       => esc_html__( 'Global Highlight Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a global color, This setting apply to all links, menu, category overlays, main page and many contrasting elements.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'dark_global_color',
					'title'       => esc_html__( 'Dark Mode - Global Highlight Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a global color in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'     => 'section_end_global_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_accent_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Dark Accent Colors', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'accent_color',
					'title'       => esc_html__( 'Dark Accent Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a dark accent color for your site, This setting apply to single header background, gradient colors.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'dark_accent_color',
					'title'       => esc_html__( 'Dark Mode - Dark Accent Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select dark accent color in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'     => 'section_end_accent_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_dark_bg_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Dark Mode Background', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'dark_background',
					'title'       => esc_html__( 'Dark Mode Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a dark solid background for the dark mode. Leave blank to set it as the default.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'     => 'section_end_dark_bg_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_mode_switcher',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Mode Switcher', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'light_switcher_color',
					'title'       => esc_html__( 'Light Switcher - Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for for the sun icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'          => 'light_switcher_bg',
					'title'       => esc_html__( 'Light Switcher - Icon Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the sun icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				),
				array(
					'id'          => 'light_switcher_slide',
					'title'       => esc_html__( 'Light Switcher - Slide Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the slider in light mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				),
				array(
					'id'          => 'dark_switcher_color',
					'title'       => esc_html__( 'Dark Switcher - Icon Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color for for the moon icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				),
				array(
					'id'          => 'dark_switcher_bg',
					'title'       => esc_html__( 'Dark Switcher - Icon Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the moon icon.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				),
				array(
					'id'          => 'dark_switcher_slide',
					'title'       => esc_html__( 'Dark Switcher - Slide Background', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a background for the slider in dark mode.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
				),
				array(
					'id'     => 'section_end_mode_switcher',
					'type'   => 'section',
					'class'  => 'ruby-section-end',
					'indent' => false
				),
				array(
					'id'     => 'section_start_miscellaneous_color',
					'type'   => 'section',
					'class'  => 'ruby-section-start',
					'title'  => esc_html__( 'Miscellaneous', 'foxiz' ),
					'indent' => true
				),
				array(
					'id'          => 'review_color',
					'title'       => esc_html__( 'Review Star Color', 'foxiz' ),
					'subtitle'    => esc_html__( 'Select a color value for the star icons.', 'foxiz' ),
					'type'        => 'color',
					'transparent' => false,
					'validate'    => 'color',
				),
				array(
					'id'     => 'section_end_miscellaneous_color',
					'type'   => 'section',
					'class'  => 'ruby-section-end no-border',
					'indent' => false
				)
			)
		);
	}
}
